package com.androidbook.simplepreferences;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public abstract class SuperSimplePreferencesActivity extends Activity {

	public static final String PREFERENCE_FILENAME = "AppPrefs";
	public static final String PREFERENCE_STRING_NAME = "StringPrefActivity";	
	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
				
		setContentView(R.layout.main);
        
		// Rozdzielenie bieżących właściwości.
        SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0); 
        SharedPreferences settingsActivity = getPreferences(MODE_PRIVATE); 

        // Wyświetlenie nazwy aktywności.
        final TextView activityName = (TextView)findViewById(R.id.Title);
        activityName.setText(this.getLocalClassName());
        
        // Wyświetlenie wspólnych właściwości.
        final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);
        prefs.setText(settings.getAll().toString());
        
        // Ustawienie prywatnych właściwości aktywności.
        final TextView prefsAct = (TextView)findViewById(R.id.CurrentActivityPrefs);
        prefsAct.setText(settingsActivity.getAll().toString());
        
        // Przejście do innej aktywności.
        final Button goButton = (Button) findViewById(R.id.ButtonGo);         
        goButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
        	    // Przejście do ekranu głównego. 
        	    Intent intent = new Intent(SuperSimplePreferencesActivity.this, GetTargetClass());
        	    startActivity(intent);
        	}         
        });
        
        
        // Obsługa przycisków aktywności.
        
        // Obsługa przycisku dodaj/zmień właściwość aktywności
        final Button prefAddActButton = (Button) findViewById(R.id.ButtonAddActivityPref);         
        prefAddActButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
     
        		final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
        		final EditText prefValue = (EditText)findViewById(R.id.EditTextPrefValue);
        		final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();
                
                String strPrefName = prefName.getText().toString();
                String strPrefValue = prefValue.getText().toString();
                               
                // Dodanie właściwości i zatwierdzenie zmian.
                prefEditor.putString(strPrefName, strPrefValue);
                prefEditor.commit();
                
                // Aktualizacja interfejsu użytkownika.
        		prefs.setText(settings.getAll().toString()); 

        		}         
        	});
        
        // Obsługa wyczyszczenia właściwości (o podanej nazwie) aktywności  
        final Button clearActPrefByNameButton = (Button) findViewById(R.id.ButtonClearActPrefByName);         
        clearActPrefByNameButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
        		final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
        		final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();
                
                String strPrefName = prefName.getText().toString();
                
                // Usunięcie właściwości jeśli istnieje. 
                if(settings.contains(strPrefName))
                {
                	// Usunięcie istniejącej właściwości o identycznej nazwie.
                	prefEditor.remove(strPrefName);
                }
                
                // Zatwierdzenie zmian i aktualizacja interfejsu użytkownika.
                prefEditor.commit();
                
        		prefs.setText(settings.getAll().toString()); 

        	}         
        });

        // Obsługa przycisku usunięcia właściwości.
        final Button clearButton = (Button) findViewById(R.id.ButtonClearAct);         
        clearButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
        		final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();
                                
                // Usunięcie wszystkich właściwości.
                prefEditor.clear();
                prefEditor.commit();
                
                // Aktualizacja interfejsu użytkownika.
        		prefs.setText(settings.getAll().toString()); 

        		// Wyświetlenie użytkownikowi informacji o tym co zrobiliśmy.
        		Toast.makeText(SuperSimplePreferencesActivity.this, "Usunięto wszystkie właściwości aktywności.", Toast.LENGTH_SHORT).show();
        		}         
        	});
        
        // Obsługa przycisków właściwości wspólnych.
        
        // Obsługa przycisku Dodaj/zmień właściwość wspólną.
        final Button prefButton = (Button) findViewById(R.id.ButtonAddSharedPref);         
        prefButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
     
        		final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
        		final EditText prefValue = (EditText)findViewById(R.id.EditTextPrefValue);
        		final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();
                
                String strPrefName = prefName.getText().toString();
                String strPrefValue = prefValue.getText().toString();
                               
                // Dodanie właściwości i zatwierdzenie zmian.
                prefEditor.putString(strPrefName, strPrefValue);
                prefEditor.commit();
                
                // Aktualizacja interfejsu użytkownika.
        		prefs.setText(settings.getAll().toString()); 

        		}         
        	});
        
        // Obsługa przycisku usunięcia właściwości na podstawie nazwy.
        final Button clearPrefByNameButton = (Button) findViewById(R.id.ButtonClearSharedPrefByName);         
        clearPrefByNameButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
        		final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
        		final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();
                
                String strPrefName = prefName.getText().toString();
                
                // Usunięcie właściwości jeśli istnieje. 
                if(settings.contains(strPrefName))
                {
                	// Usunięcie istniejącej właściwości o takiej samej nazwie.
                	prefEditor.remove(strPrefName);
                }
                
                // Zatwierdzenie zmian i aktualizacja interfejsu użytkownika.
                prefEditor.commit();
                
        		prefs.setText(settings.getAll().toString()); 

        	}         
        });

        
        
        // Obsługa przycisku usunięcia właściwości.
        final Button clearSharedButton = (Button) findViewById(R.id.ButtonClearShared);         
        clearSharedButton.setOnClickListener(new View.OnClickListener() {             
        	public void onClick(View v) {                 
  
        		final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);
        		
        		// Pobranie ustawień aplikacji i otworzenie edytora.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();
                                
                // Usunięcie wszystkich właściwości.
                prefEditor.clear();
                prefEditor.commit();
                
                // Aktualizacja interfejsu użytkownika.
        		prefs.setText(settings.getAll().toString()); 

        		// Wyświetlenie użytkownikowi informacji o tym co zrobiliśmy. 
        		Toast.makeText(SuperSimplePreferencesActivity.this, "Usunięto wszystkie właściwości wspólne.", Toast.LENGTH_SHORT).show();
        	}         
        });
        
        // Rejestrujemy odbiorcę zdarzeń, by wiedzieć kiedy właściwości zostaną zmodyfikowane.
        settings.registerOnSharedPreferenceChangeListener(new SharedPreferences.OnSharedPreferenceChangeListener() {             
        	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {   
        	    // Informujemy użytkownika o tym co się zmieniło.
        		Toast.makeText(SuperSimplePreferencesActivity.this, "Zmieniono właściwość: "+key, Toast.LENGTH_SHORT).show();
        	}         
        });
		
	}
	
	abstract Class<?> GetTargetClass();
	

}
